%
% r=randt(nu,m,n)
%
% Generates an m by n matrix of random numbers with a t distribution with
% nu degrees of freedom.  
%
function r=randt(nu,m,n)
%
% if m,n not specified, then use 1,1.
%
if (nargin==1),
  m=1;
  n=1;
end
U=rand(m,n);
r=zeros(m,n);
for i=1:m
  for j=1:n
    r(i,j)=tinv(U(i,j),nu);
  end
end
