function retval = norm_rnd(mu,sigma,m,n)
% Usage: rndx = norm_rnd(mu,sigma,m,n)
% Description: This program accepts scalar arguments mu
% and sigma, and index arguments m and n  and returns an
% array of size mxn of random numbers generated from a
% gamma distribution with parameters:
%   mu, mean of distribution
%   sigma, standard deviation of distribution
% in the standard description.
% last index n is optional, with a default value of 1.
% The builtin uniform random number generator rand is
% used so resetting the seed is accomplished via rand.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 3)
  error('norm_rnd: need three arguments');
end
if (sigma < 0)
  error('norm_rnd: parameter sigma  must be positive');
end
if (m < 1)
  error('norm_rnd: row number m must be positive integer');
end
if (nargin == 4)
  if (n < 1)
    error('norm_rnd: column number must be positive integer');
  end
else
  n = 1;
end
retval = randn(m,n);

