function retval = norm_pdf(x,mu,sigma)
% Usage: pdfx = norm_pdf(x,mu,sigma)
% Description: This program accepts matrix argument x, scalars
% mu and sigma and returns the p.d.f. for the normal
% distribution evaluated at x with parameters:
%   mu, mean of distribution
%   sigma, standard deviation of distribution
% in the standard description.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 3)
  error('norm_pdf: need three arguments');
end
if (sigma < 0)
  error('norm_pdf: parameter sigma must be positive');
end
retval = 1./exp((x-mu).^2/(2*sigma^2))/sqrt(2*pi)/sigma;
