function retval = norm_inv(p,mu,sigma)
% Usage: invpdfx = norm_inv(p,mu,sigma)
% Description: This program accepts matrix argument p of
% probabilities, scalars mu and sigma and returns the
% inverse c.d.f. for the normal distribution evaluated
% at x with parameters:
%   mu, mean of distribution
%   sigma, standard deviation of distribution
% in the standard description.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 3)
  error('norm_inv: need three arguments');
end
if (sigma < 0)
  error('norm_inv: parameter sigma must be positive');
end
if (sum(sum((p > 1) | (p < 0))))
  error('norm_inv: p must have values between zero and one');
end
retval = mu + sigma.*sqrt(2)*erfinv(2*p-1);