function retval = norm_cdf(x,mu,sigma)
% Usage: pdfx = norm_cdf(x,mu,sigma)
% Description: This program accepts matrix argument x, scalars
% mu and sigma and returns the c.d.f. for the normal
% distribution evaluated at x with parameters:
%   mu, mean of distribution
%   sigma, standard deviation of distribution
% in the standard description.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 3)
  error('norm_cdf: need three arguments');
end
if (sigma < 0)
  error('norm_cdf: parameter sigma must be positive');
end
retval = (1+erf((x-mu)/(sigma*sqrt(2))))/2;
