function retval = irr(cf)
% usage:  pv = irr(cf)
% description: Returns yield (internal rate of return)
% of a single cash flow stream vector cf.

% Contact: Tom Shores, tshores@math.unl.edu

% local variables:
% _fcn: temporary function

% a little bit of bulletproofing
if (nargin ~= 1)
  error('irr: needs one argument: cf');
end
if (~isvector(cf))
  error('irr: needs a vector argument');
end
% allow for column vectors
if (size(cf,2) == 1)
  cf = cf';
end
% the actual calculation
retval = 1/fzero(@(x) polyval(fliplr(cf),x),1) - 1;
