function retval = gamm_pdf (x,a,b)
% Usage: pdfx = gamm_pdf(x,a,b)
% Description: This program accepts matrix argument x, scalars a
% and b and returns the p.d.f. for the gamma distribution 
% evaluated at x with parameters:
%   a = alpha
%   b = beta
% in the standard description so that the distribution has
% mean alpha*beta and variance alpha*beta^2.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 3)
  error('gamm_pdf: need three arguments');
end
if ((a < 0) | (b < 0))
  error('gamm_pdf: parameters a, b must be positive');
end
x = max(x,0);
retval = x .^ (a-1) .* exp(-x/b) ./ (gamma(a)*b^a);
