function retval = exp_rnd(lam,m,n)
% Usage: xexp= exp_rnd(lam,m,n)
% Description: This program accepts scalar arguments lam
% and index arguments m and n  and returns an array
% of size mxn of random numbers generated from exponential
% distribution with parameter:
%   lambda = lam
% in the standard description so that the distribution has
% mean 1/lambda and variance 1/lambda^2. The
% last index n is optional, with a default value of 1.
% The builtin uniform random number generator rand is
% used so resetting the seed is accomplished via rand.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 2)
  error('exp_rnd: need two arguments');
end
if (lam < 0)
  error('exp_rnd: parameter lam must be positive');
end
if (m < 1)
  error('exp_rnd: row number m must be positive integer');
end
if (nargin == 3)
  if (n < 1)
    error('exp_rnd: column number must be positive integer');
  end
else
  n = 1;
end
retval = rand(m,n);
retval = exp_inv(retval,lam);
