function retval = exp_pdf (x,lam)
% Usage: pdfx = exp_pdf(x,lam)
% Description: This program accepts matrix argument x, scalar
% lam and returns the p.d.f. for the exponential distribution
% evaluated at x with parameter:
%   lam = lambda
% in the standard description so that the distribution has
% mean 1/lambda and variance 1/lambda^2.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 2)
  error('exp_pdf: need two arguments');
end
if (lam < 0)
  error('lam_pdf: parameter lam must be positive');
end
x = max(x,0);
retval = lam*exp(-lam*x);
