% script for Exercise 3.1 (text 3.1)
clear
% get the data
load 'ifk.mat'
m = length(d);
y = linspace(0.025,0.975, m)';
% let's do an experiment and see what we believe
msolns = zeros(m,m);
xgrid = zeros(m,m);
tabledata = zeros(m,4);
for ii = 1:m;
  % here is our discretization size:
  n = ii;
  dx = 1/n;
  x = linspace(dx/2,1-dx/2,n)';
  [X,Y] = meshgrid(x,y);
  G = X.*exp(-X.*Y)*dx;
  % record the solution
  m = G\d;
  msolns(1:ii,ii) = m;
  xgrid(1:ii,ii) = x;
  tabledata(ii,:) = [ii,norm(d-G*m), norm(m), cond(G)];
end
disp(' ')
disp('Discretiz Size   Resid Norm  Soln Norm  Cond of G')
disp('--------------------------------------------------')
disp(tabledata)
% it might be interesting to do a few plots
hold on, grid
n = 3; plot(xgrid(1:n,n),msolns(1:n,n));
n = 4; plot(xgrid(1:n,n),msolns(1:n,n));
n = 5; plot(xgrid(1:n,n),msolns(1:n,n));
title('Exercise 3.1 Solution Graphs for n=3,4,5')

