% code for Exercise 2.3 of Math 496 (text B10 of Appendix B)
% generate samples
clear
rand('seed',0)
mu = 10
sigma = 10;
lambda = 1/mu
n = 50
m = 1000
samples = exp_rnd(lambda,n,m);
means = mean(samples);
% ok, now let's set the scale as follows:
% use 30 bins over three standard deviations
samplesigma = sigma/sqrt(n);
bindelta = samplesigma/5;
databin = mu-3*samplesigma:bindelta:mu+3*samplesigma;
hist(means,databin);
title('Histogram of 1000 50-Sample Means From Exponential Distribution');
hst = hist(means,databin);
scaledhst = hst/bindelta/sum(hst);
figure;
bar(databin,scaledhst);
title('Probability Plot (p.d.f.) of 1000 50-Sample Means From Exponential Distribution');
% ok, let's plot the real thing in probability plots, incorrectly
% called a "Q-Q plot" in Appendix B of text.
d = sort(means);
x = norm_inv(linspace(0.5/m,(m-0.5*m)/m,m),0,1);
figure
plot(x,d,'o');
title('Probability Plot of 1000 50-Sample Means from Exponential Distribution');
% just for the record, here is a Q-Q plot:



