function retval = chis_pdf(x,r)
% Usage: gammx = chis_pdf(x,r)
% Description: This program accepts matrix argument x,
% scalar r returns the p.d.f. for the chi-square
% distribution evaluated at x with parameters:
%   r =  degrees of freedom
% in the standard description so that the distribution has
% mean r and variance 2*r.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 2)
  error('chis_pdf: need two arguments');
end
if (r < 0)
  error('chis_pdf: parameter r must be positive');
end
x = max(x,0);
retval = gamm_pdf(x,r/2,2);
