%
% p=chi2cdf(x,m)
%
% Computes the Chi^2 CDF, using a transformation to N(0,1) on page 333
% of Thistead, Elements of Statistical Computing.
%
% Note that x and m must be scalars.
%
function p=chi2cdf(x,m)
if (x == (m-1)),
  p=0.5;
else
  z=(x-m+2/3-0.08/m)*sqrt((m-1)*log((m-1)/x)+x-(m-1) )/abs(x-m+1);
  p=phi(z);
end
