% script: WorkingExample.m

data = KCCData()
M = data(:,1:5)
P = data(:,2:6)
Template = [1 0 1;1 1 0; 0 1 1]
G = proj2coef(Template,M)
d = vec(P)
rankG = rank(G)
sizeG = size(G)
soln = G\d
A = coef2proj(Template,soln)
misfit = norm(A*M - P, 'fro')
evals = eig(A)
disp('Set up for Woods quadratic program:')
disp('Press a key to start...')
pause
Hw = G'*G
gw = -2*G'*d
% if the template changes, so does this matrix
Lw = [-1 -1 0 0 0 0; 0 0 -1 -1 0 0; 0 0 0 0 0 -1]
bw = [-1 -1 -1]';
woodsoln = quad_prog(Hw,gw,Lw,bw)
Awood = coef2proj(Template,woodsoln)
Awoodmisfit = norm(Awood*M - P, 'fro')
evals = eig(Awood)



