%
%  Calculates the normal distribution.  
%
%   z=phi(x) 
%
%  gives z=int((1/sqrt(2*pi))*exp(-t^2/2),t=-infinity..x)
%
function z=phi(x)
if (x >= 0) 
  z=.5+.5*erf(x/sqrt(2));
else
  z=1-phi(-x);
end

