function [mu, sigma, muci, sigmaci] = norm_fit(x,alpha)
% usage: [mu, sigma, muci, sigmaci] = norm_fit(x,alpha)
% description: Given input vector x and optional alpha (default=0.05) of
% confidence level (1-alpha), returns the sample mean mu, sample variance
% sigma, and vectors of lower,upper limits of confidence intervals
% for x. Student's t distribution is used for interval calculations.

% this isn't very robust in Octave. Fails for n>300. 

if (nargin == 1)
  alpha = 0.05;
end
n = length(x);
mu = mean(x);
sigma = sqrt(var(x));
talpha = tdis_inv(alpha/2,n-1);
muci = [mu + talpha*sigma/sqrt(n); mu - talpha*sigma/sqrt(n)];
sigmaci = [(n-1)*sigma^2/chis_inv(alpha/2,n-1); (n-1)*sigma^2/chis_inv(1-alpha/2,n-1)];
