function retval = irroct(cf)
% usage:  pv = irroct(cf)
% description: Returns yield (internal rate of return)
% of a single cash flow stream vector cf. This routine
% is designed for Octave.

% local variables:
% _fcn: temporary function

% Contact: Tom Shores, tshores@math.unl.edu

% a little bit of bulletproofing
if (nargin ~= 1)
  error('irr: needs one argument: cf');
end
if (~isvector(cf))
  error('irr: needs a vector argument');
end
% allow for column vectors
if (size(cf,2) == 1)
  cf = cf';
end
% the actual calculation
retval = roots(fliplr(cf));
retval = 1./max(retval(find(abs(imag(retval))<=100*eps*abs(imag(retval)))))-1;
