function retval = exp_inv(p,lam)
% Usage: expinvp = exp_inv(p,lam)
% Description: This program accepts matrix argument x of
% probabilities, scalar lam and returns the inverse p.d.f.
% for the exponential distribution evaluated at x with parameter:
%   lam = lambda
% in the standard description so that the distribution has
% mean 1/lambda and variance 1/lambda^2.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 2)
  error('exp_inv: need three arguments');
end
if (lam < 0)
  error('exp_inv: parameter lam must be positive');
end
if (sum(sum((p > 1) | (p < 0))))
  error('gamm_inv: p must have values between zero and one');
end
retval = abs(log(1-p)/lam);
