function NumDays = daysbetween( StartDate, EndDate, Basis )
%daysbetween Days between dates based on specified basis
%  Given two dates in serial date numbers or date strings, calculate the
%  number of days between them based on specified basis
%
%  NumDays = daysbetween(StartDate, EndDate)
%
% Inputs:
%  StartDate (required) - The starting date in serial date number or date
%  string format
%  EndDate (required) - The ending date in serial date number or date
%  string format.  Defaults to the MATLAB base date (1-Jan-0000 AD)
%  Basis - Day-count basis: 0 = actual/actual (default), 1 = 30/360 (SIA),
%  2= actual/360, 3 = actual/365, 4 = 30/360 (PSA), 5 = 30/360 (ISDA), 6 =
%  30/360 (European), 7 = actual/365 (Japanese)

%  Author(s): B. Blunk 02/11/05 bblunk@unlnotes.unl.edu

if(Basis == 0)
    NumDays = daysact(StartDate, EndDate);
elseif(Basis ==1)
    NumDays = days360(StartDate, EndDate);
else
    error('Basis'' other than 0 or 1 are not currently supported');
end