function retval = chis_rnd(r,m,n)
% Usage: chisrnd = chis_rnd(r,m,n)
% Description: This program accepts scalar argument r
% and index arguments m and n  and returns an array
% of size mxn of random numbers generated from a
% Chi-square distribution with parameter:
%   r =  degrees of freedom
% in the standard description so that the distribution has
% mean r and variance 2*r.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 2)
  error('chis_rnd: need two arguments');
end
if (r < 0)
  error('chis_rnd: parameter r must be positive');
end
if (nargin == 3)
  if (n < 1)
    error('chis_rnd: column number must be positive integer');
  end
else
  n = 1;
end
retval = gamm_rnd(r/2,2,m,n);
