function retval = chis_inv(p,r)
% Usage: gammx = chis_inv(p,r)
% Description: This program accepts matrix argument p of
% probabilities, scalar r returns the inverse c.d.f. for
% the chi-square distribution evaluated at p with parameters:
%   r =  degrees of freedom
% in the standard description so that the distribution has
% mean r and variance 2*r.

% Contact: T. Shores at tshores1@math.unl.edu

if (nargin < 2)
  error('chis_inv: need two arguments');
end
if (r < 0)
  error('chis_inv: parameter r must be positive');
end
if (sum(sum((p > 1) | (p < 0))))
  error('gamm_inv: p must have values between zero and one');
end
retval = gamm_inv(p,r/2,2);
