function [mu, sigma, muci, sigmaci] = norm_fit(x,alpha)
% usage: [mu, sigma, muci, sigmaci] = norm_fit(x,alpha)
% description: Given input vector x and optional alpha (default=0.05) of
% confidence level (1-alpha), returns the sample mean mu, sample variance
% sigma, and vectors of lower,upper limits of confidence intervals
% for mu and sigma. Student's t distribution is used for interval
% calculation for mu, standard for interval calculation for sigma.
% Caution: sigmaci is not to be trusted for length(x) > 340 due to a
% a limitation of gamm_pdf.m

if (nargin == 1)
  alpha = 0.05;
end
n = length(x);
mu = mean(x);
sigma = sqrt(var(x));
talpha = stdn_inv(alpha/2);
muci = [mu + talpha*sigma/sqrt(n); mu - talpha*sigma/sqrt(n)];
n = min(340,n); % a kludge to keep the program from folding
sigmaci = sqrt([(n-1)*sigma^2/chis_inv(1-alpha/2,n-1); (n-1)*sigma^2/chis_inv(alpha/2,n-1)]);
