function retval = fvvar(cf,r)
% usage:  pv = fvvar(cf,r)
% description: Returns vector of future values of a
% single cash flow stream vector cf at periodic 
% discount rates (in decimal format) specified by 
% vector r. It is assumed that the first entry of cf
% is paid at time zero and subsequent entries are paid
% at the end of successive periods. 

% Contact: Tom Shores, tshores@math.unl.edu

% local variables:
% ii: index variable

% a little bit of bulletproofing
if (nargin ~= 2)
  error('fvvar: need two arguments: cf,r');
end
if (sum(r <=-1))
  error('fvvar: discount rate entries of r have to be scalar > -1');
end
if (length(cf) ~= size(cf,1)*size(cf,2))
  error('fvvar: cash flow cf has to be a vector');
end
% make sure cf is column vector
cf = cf(:)';
% the actual calculation
retval = zeros(size(r));
for ii = (1:length(retval))
  retval(ii) = sum(cf .* (1+r(ii)).^fliplr((0:length(cf)-1)));
end
