function NumDays = days360( StartDate, EndDate )
%daysact Days between dates based on 360-day year (SIA Compliant)
%  Given two dates in serial date numbers or date strings, calculate the
%  number of days between them based on a 360-day year
%
%  NumDays = days360(StartDate, EndDate)
%
% Inputs:
%  StartDate (required) - The starting date in serial date number or date
%  string format
%  EndDate (required) - The ending date in serial date number or date
%  string format.  Defaults to the MATLAB base date (1-Jan-0000 AD)

%  Author(s): B. Blunk 02/11/05 bblunk@unlnotes.unl.edu

if(nargin < 2)
    error('You must specify StartDate and EndDate')
end

if ((size(StartDate,1) ~= 0) & (size(EndDate,1) ~=0) & (size(EndDate,1) ~= size(StartDate,1)))
    error('StartDate and EndDate must be of same size or scalar')
end

StartVec = datevec(StartDate);
EndVec = datevec(EndDate);


Years = EndVec(:,1) - StartVec(:,1);
Months = EndVec(:,2) - StartVec(:,2);
Days = EndVec(:,3) - StartVec(:,3);

NumDays = Years .* 12 .* 30 + Months .* 30 + Days;