function retval = bseurput(S, K, r, T, t, sigma, D0)
% usage: PutPrice = bseurput(S, K, r, T, t, sigma, D0)
% description: Calculates the price of a European put given
% initial stock value S, strike price K, risk-free rate r,
% expiry time T, present time t, standard deviation sigma, and
% optional continuous dividend yield D0 with default zero.

% contact: tshores@math.unl.edu

if (nargin < 6)
    error('bseurput: needs 6 arguments: S, K, r, T, t, sigma');
end
if (nargin < 7)
  D0 = 0;
end

retval = bseurcall(S,K,r,T,t,sigma,D0) + K*exp(-r*(T-t)) - ...
         S*exp(-D0*(T-t));