function retval = bseurcall(S, K, r, T, t, sigma, D0)
% usage: CallPrice = bseurcall(S, K, r, T, t, sigma, D0)
% description: Calculates the price of a European call given
% initial stock value S, strike price K, risk-free rate r,
% expiry time T, present time t, standard deviation sigma, and
% optional continuous dividend yield D0 with default zero.

% contact: Matthew Johnson (msjohnso@unlnotes.unl.edu)

% local variables: d10, d20, t

if (nargin < 6)
    error('bseurcall: needs 6 arguments: S, K, r, T, t, sigma');
end
if (nargin ~= 7)
  D0 = 0;
end

% calculate d10 and d20
d10 = (log(S ./ K) + (r - D0 + sigma .* sigma / 2) .* (T - t)) / (sigma .* sqrt(T - t));
d20 = d10 - sigma .* sqrt(T - t);

% use the formula from the lecture notes
% assumes the existence of the norm_cdf function
retval = exp(-D0 .* (T - t)) .* S .* norm_cdf(d10,0,1) - K .* exp(-r .* (T - t)) .* norm_cdf(d20,0,1);
