function retval = Tridiag(n,a,b,c)
% usage: Tridiag(n,a,b,c)
% description: returns tridiagonal matrix with diags a,b,c of size n
% or with a,b,c down the diagonals, suitably trimmed.

% local variables:
% ii,jj: index variables

retval = zeros(n,n);
if (length(a)>1) % build from diagonals
  retval = diag(a(2:n),-1)+diag(b)+diag(c(1:n-1),1);
else  
  retval(1,1) = b;
  retval(1,2) = c;
  retval(n,n-1) = a;
  retval(n,n) = b;
  for ii = 2:(n-1)
    retval(ii,ii-1) = a;
    retval(ii,ii) = b;
    retval(ii,ii+1) = c;
  end;
end
