function retval = DownOutPut(S0, K, r, T, t, sigma, Sb)
% usage: PutPrice = DownOutPut(S, K, r, T, t, sigma, Sb)
% description: Calculates the price of a European down-and-out
% put, given initial stock value S, strike price K, risk-free
% rate r, expiry time T, present time t, standard deviation
% sigma, and lower barrier Sb (no dividends.)


if (nargin < 7)
    error('bseurcall: needs 7 arguments: S, K, r, T, t, sigma, Sb');
end

a = (Sb./S0).^(-1+2*r/sigma^2);
b = (Sb./S0).^(1+2*r/sigma^2);
sigmasqrtTt=sigma*sqrt(T-t);
d1 = (log(S0/K) + (r+sigma^2/2)*(T-t))/sigmasqrtTt;
d2 = (log(S0/K) + (r-sigma^2/2)*(T-t))/sigmasqrtTt;
d3 = (log(S0/Sb) + (r+sigma^2/2)*(T-t))/sigmasqrtTt;
d4 = (log(S0/Sb) + (r-sigma^2/2)*(T-t))/sigmasqrtTt;
d5 = (log(S0/Sb) - (r-sigma^2/2)*(T-t))/sigmasqrtTt;
d6 = (log(S0/Sb) - (r+sigma^2/2)*(T-t))/sigmasqrtTt;
d7 = (log(S0*K/Sb^2) - (r-sigma^2/2)*(T-t))/sigmasqrtTt;
d8 = (log(S0*K/Sb^2) - (r+sigma^2/2)*(T-t))/sigmasqrtTt;
retval = K*exp(-r*(T-t))*(stdn_cdf(d4)-stdn_cdf(d2) - ...
         a.*(stdn_cdf(d7) - stdn_cdf(d5))) ...
         -S0.*(stdn_cdf(d3) - stdn_cdf(d1) - ...
         b.*(stdn_cdf(d8) - stdn_cdf(d6)));