function [Price,CI] = BlsMCAV(S0,K,r,T,sigma,NReps)
% usage: [Price,CI] = BlsMCAV(S0,K,r,T,sigma,NReps)
% description: returns 95% confidence interval and estimate
% of price of vanilla European call by Monte Carlo simulation
% and antithetic variables. From p. 247 of Brandimarte

nuT = (r - 0.5*sigma^2)*T;
siT = sigma*sqrt(T);
Veps = randn(NReps,1);
Payoff1 = max(0, S0*exp(nuT+siT*Veps) - K);
Payoff2 = max(0, S0*exp(nuT+siT*(-Veps)) - K);
DiscPayoff = exp(-r*T)*0.5*(Payoff1 + Payoff2);
[Price,VarPrice,CI] = norm_fit(DiscPayoff);
