function SPaths = AssetPaths(S0,mu,sigma,T,NSteps,NReps)
% usage: SPaths = AssetPath(S0,mu,sigma,T,NSteps,NReps)
% description: returns NReps rows whose entries are a random path
% for asset with drift mu, volatility sigma and initial price S0,
% starting at t=0 ending with t=T in steps of dt = T/NSteps.
SPaths = zeros(NReps,NSteps+1);
SPaths(:,1) = S0;
dt = T/NSteps;
nudt = (mu-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
for i = 1:NReps
  for j = 1:NSteps
    SPaths(i,j+1) = SPaths(i,j)*exp(nudt + sidt*randn);
  end
end
