function retval = AssetPath(S0,mu,sigma,T,NSteps,NReps)
% usage: SPaths = AssetPath(S0,mu,sigma,T,NSteps,NReps)
% description: returns NReps rows whose entries are a random path
% for asset with drift mu, volatility sigma and initial price S0,
% starting at t=0 ending with t=T in steps of dt = T/NSteps.

dt = T/NSteps;
Increments = (mu - 0.5*sigma^2)*dt + sigma*sqrt(dt)*randn(NReps,NSteps);
retval = exp(cumsum([log(S0)*ones(NReps,1),Increments],2));
