function Vaccination()

% Runs a numerical simulation of a distribution-limited vaccination model.
% Shows the impact of vaccine refusal.

% by Glenn Ledder
% written 2022/02/22
% revised 2022/04/17

% direct comments to gledder@unl.edu

%% DATA

% Define problem parameters

avals = [0.6,0.8];
phi = 0.02;

% Define time interval

interval = [0 100];

% Define the function that determines the derivatives.

function dWdt = rates(tt,WW)
    dWdt = -phi*WW;
end

%% INITIALIZATION

% Set up plots

clf
hold on
box on

%% COMPUTATION and PLOTS

% Calculate a vector t and matrix yy that contains the solution at 
%   discrete points

for i=1:length(avals)
    a = avals(i);
    [t,W] = ode45(@rates,interval,a);
    V = a-W;
    plot(t,V,'LineWidth',1.4)
end

%% OUTPUT

% use 'FontSize',18 / 16 in Octave
xlabel('\it{t}','FontSize',14)
ylabel('\it{V}','FontSize',12,'Rotation',0)

%% END

end