%% SEAIHRD_comparison

% Plots a comparison of population classes for multiple scenarios

% Uses seaihrd.m, 2022/03/06 version

% User specifies a list of values for one of the key parameters:
%   R0 is the basic reproductive number
%   c is the fraction of infectious patients (I+J) who are confirmed
%   delta is the contact factor
%   h0 is the initial hopitalization count per 100K

% e0 is calculated assuming exponential growth phase

% The program is designed so that only two lines need to be modified to
% make a new experiment (see '%%%' comments)
%     line 51 defines the independent variable values
%     line 78 links the independent variable name and values
% The legend is optional

% output figure:
%   top left panel:  fraction S vs time
%   top right panel: total fraction I vs time
%   bottom left panel: US deaths (thousands) vs time
%   bottom right panel: H per 100K vs time

% by Glenn Ledder
% written 2022/01/24
% revised 2022/03/06

% direct comments to gledder@unl.edu

beds = 280;

%% DEFAULT SCENARIO DATA

R0 = 5.7;
c = 0.1;
delta = 1;
h0 = 1;

% use 1 for square axes or 0 for nonfixed aspect ratio

sq = 0;

%% INDEPENDENT VARIABLE DATA

%%% This section needs to be modified for each experiment.

%%% xvals is the set of independent variable values
xvals = [0.1,0.3,0.5,0.7];

%% INITIALIZATION

clf
for k=1:4
    subplot(2,2,k)
    hold on
    box on
    if sq>0
        axis square
    end
    xlabel('days')
end

N = length(xvals);
finalpctS = zeros(1,N);
USdeaths = zeros(1,N);
maxH = zeros(1,N);
maxday = zeros(1,N);

%% COMPUTATION and PLOTS

for n=1:N
    
    %%% The left side of this statement needs to be the independent
    %%% variable for the experiment.
    c = xvals(n);

    [S,~,A,I,J,H,~,D] = seaihrd(R0,c,delta,h0);
    days = length(I)-1;
    times = 0:days;
    
    [M,d] = max(H);
    maxH(n) = M;
    maxday(n) = d-1;
    finalpctS(n) = 100*S(end);
    USdeaths(n) = 325000*D(end);
    
    subplot(2,2,1)
    plot(times,S,'LineWidth',1.4)
    subplot(2,2,2)
    plot(times,A+I+J+H,'LineWidth',1.4)
    subplot(2,2,3)
    plot(times,325000*D,'LineWidth',1.4)
    subplot(2,2,4)
    plot(times,100000*H,'LineWidth',1.4)
end

subplot(2,2,1)
ylim([0,1])
ylabel('susceptible')
subplot(2,2,2)
ylabel('infectious')
subplot(2,2,3)
ylabel('US deaths (thousands)')
subplot(2,2,4)
plot([0,days],[beds,beds],'k--')
ylabel('hospitalizations per 100K')

%% OUTPUT

% final %S
finalpctS = finalpctS

% US deaths (thousands)
USdeaths = USdeaths

% maximum hospitalizations per 100K
maxHp100K = 100000*maxH
maxday = maxday
