%%% LeastSq_1var

% finds optimal m for the linear model Y=mX with RSS and AIC

%   X,Y are the lists of data values

% only DATA needs to be changed for each problem

% by Glenn Ledder
% written 2021/03/12
% revised 2021/08/31

%% DATA

% comment out clf to add curve to existing plot

clf

% enter data

X = 0:10:140;
Y = [0 2 7 10 9 14 21 20 25 20 30 25 29 35 38];

% choose axis labels

xname = '\it{X}';
yname = '\it{Y}';

% choose curve color

col = 'k';

%% COMPUTATION

% compute best fit slope

sumx2 = sum(X.^2);
sumxy = sum(X.*Y);
sumy2 = sum(Y.^2);
mstar = sumxy/sumx2;

% compute RSS and AIC

RSS = sumy2-mstar*sumxy;
n = length(X);
AIC = n*log(RSS/n)+4;

%% OUTPUT

hold on
box on

% use 'MarkerSize',6 in Octave
plot(X,Y,'r.','MarkerSize',12)

XX = linspace(X(1),X(end));
YY = mstar*XX;
plot(XX,YY,col,'LineWidth',1.4)

% use 'FontSize',18 in Octave
xlabel(xname,'FontSize',14);
ylabel(yname,'FontSize',14,'Rotation',0);

% display results

mstar
RSS
AIC

