%%% LeastSq

% finds optimal m for the linear model y=b+mx along with b, RSS, AIC

%   x,y are the lists of data values

% only DATA needs to be changed for each problem

% by Glenn Ledder
% written 2021/03/12
% revised 2021/08/31

%% DATA

% comment out clf to add curve to existing plot

clf

% enter data

x = 0:10:140;
y = [0 2 7 10 9 14 21 20 25 20 30 25 29 35 38];

% choose axis labels

xname = '\it{x}';
yname = '\it{y}';

% choose curve color

col = 'k';

%% COMPUTATION

% convert data

xbar = sum(x)/length(x);
ybar = sum(y)/length(y);
X = x-xbar;
Y = y-ybar;

% compute best fit slope and intercept

sumx2 = sum(X.^2);
sumxy = sum(X.*Y);
sumy2 = sum(Y.^2);
mstar = sumxy/sumx2;
bstar = ybar-mstar*xbar;

% compute RSS and AIC

RSS = sumy2-mstar*sumxy;
n = length(X);
AIC = n*log(RSS/n)+6;

%% OUTPUT

hold on
box on

% use 'MarkerSize',6 in Octave
plot(x,y,'r.','MarkerSize',12)

xx = linspace(x(1),x(end));
yy = bstar+mstar*xx;
plot(xx,yy,col,'LineWidth',1.4)

% use 'FontSize',18 in Octave
xlabel(xname,'FontSize',14);
ylabel(yname,'FontSize',14,'Rotation',0);

% display results

mstar
bstar
RSS
AIC
