function [beta,S,E,I,R]=seirabm(R0,N)
%
% function [S,E,I,R]=seirsim(beta)
%
%   runs a simulation of an agent-based SEIR model
%
% by Glenn Ledder
% written 2021/09/09
% revised 2021/09/11
%
% direct comments to gledder@unl.edu

%% DATA

mu_i = 10;
sigma_i = 1.5;
mu_e = 5;
sigma_e = 1;

maxdays = 100;

pops = zeros(24,1);
pops(8) = 1;
pops(1) = N-1;

%% INITIALIZATION

beta = 0.1*R0/N;

% create data structures

S = pops(1)*ones(maxdays+1,1);
E = N-S;
I = zeros(maxdays+1,1);
R = zeros(maxdays+1,1);
results = zeros(maxdays+1,24);
results(1,:) = pops';

% compute transition probabilities

Phi = @(x,mu,sigma) 0.5*(1+erf((x-mu)/(sqrt(2)*sigma)));

x_i = 5.5:1:14.5;
cdf_i = [0 Phi(x_i,mu_i,sigma_i) 1];
p = zeros(15,1);
p(5:15) = cdf_i(2:12)-cdf_i(1:11);

x_e = 3.5:1:6.5;
cdf_e = [0 Phi(x_e,mu_e,sigma_e) 1];
q = zeros(7,1);
q(3:7) = cdf_e(2:6)-cdf_e(1:5);

% create transition matrix
%   ij entry is flow from j at time t to i at time t+1, not counting
%   transmissions

M = zeros(24,24);
M(1,1) = 1;
M(24,24) = 1;
for j=2:23
    M(j+1,j) = 1;
end
for i=9:19
    M(i,8) = p(24-i);
end

%% COMPUTATION

for n=1:maxdays
    pops = M*pops;
    T = beta*S(n)*I(n);
    pops(1) = pops(1)-T;
    for i=2:6
        pops(i) = pops(i)+q(9-i)*T;
    end
    results(n+1,:) = pops';
    S(n+1) = pops(1);
    E(n+1) = sum(pops(2:8));
    I(n+1) = sum(pops(9:23));
    R(n+1) = pops(24);
    % check if done
    if E(n+1)+I(n+1)<0.5       
        % delete unneeded rows
        S = round(S(1:(n+1)));
        E = round(E(1:(n+1)));
        I = round(I(1:(n+1)));
        R = round(R(1:(n+1)));      
        % exit for loop
        break;
    end %if
end %for
    
%% END

end
