function [H,P,S,R]=hpsr(b,N,P0,S0)
%
% function [H,P,S,R]=hpsr(b,N,P0,S0)
%
%   runs a simulation of an agent-based model
%
%   H: healthy
%   P: presymptomatic
%   S: sick
%   R: recovered
%
%   b is the transmission probability
%   N is the total population
%   P0 is the initial presymptomatic population
%   S0 is the initial sick population
%
% by Glenn Ledder
% written 2020/11/29
% revised 2021/10/20
%
% direct comments to gledder@unl.edu

%% DATA

% suggested default values
% b = 1;
% N = 1000;
% P0 = 20;

%% INITIALIZATION

% limit simulation duration
maxdays = 100;

% set data structures using initial conditions
H = (N-P0-S0)*ones(1,maxdays+1);
P = P0*ones(1,maxdays+1);
S = S0*ones(1,maxdays+1);
R = zeros(1,maxdays+1);

%% COMPUTATION

for n=1:maxdays
        
    % calculate probability of an infected partner for a healthy person
    p = (P(n)+S(n))/(N-1);
        
    % get a 'partner' for each healthy person
    partners = rand(H(n),1);
        
    % count H's with infectious partners
    atrisk = length(find(partners<p));
        
    % get random numbers for transmission success
    exposure = rand(atrisk,1);
        
    % count atrisks with successful transmission
    infected = length(find(exposure<b));
        
    % calculate new class counts
    H(n+1) = H(n)-infected;
    P(n+1) = infected;
    S(n+1) = P(n);
    R(n+1) = R(n)+S(n);
        
    % check if done
    if P(n+1)+S(n+1)==0       
        % delete unneeded rows
        H = H(1:(n+1));
        P = P(1:(n+1));
        S = S(1:(n+1));
        R = R(1:(n+1));      
        % exit for loop
        break;
    end %if
    
end %for
    
%% END

end
