function xstar=findmin(f,xmin,xmax,tol)
%
%   finds a local minimizer of a function f
%   designed for functions that cannot be vectorized
%   initial search in [xmin,xmax]
%   search interval shifts if no sign change in slope
%   does not work for functions with frequent sign changes in slope
%
% by Glenn Ledder
% written 2020/01/07
% revised 2021/09/07
%
% direct comments to gledder@unl.edu

%% INITIALIZATION

fvals = zeros(1,11);
dx = 2*tol;

%% COMPUTATION

while dx>tol
    dx = 0.1*(xmax-xmin);
    xvals = xmin:dx:xmax;
    for i=1:length(xvals)
        fvals(i) = f(xvals(i));
    end
    [~,I] = min(fvals);
    if I==1
        xmax = xmin+dx;
        xmin = xmin-9*dx;
    elseif I==11
        xmin = xmax-dx;
        xmax = xmax+9*dx;
    else
        xstar = xvals(I);
        xmin = xstar-dx;
        xmax = xstar+dx;
    end
end %while

%% END

end
