%% SEIR_onesim

% Plots a comparison of population classes

% Prints results and outcomes (populations are fractions):
%   results is a matrix of columns for time,S,E,I,R,Delta S
%   maxI is the maximum size of class I
%   maxday is the day on which maxI occurs
%   finalS is the ending size of S

% Uses seir.m, 2020/11/27 version

% User specifies values for 6 parameters:
%   R0 is the basic reproductive number
%   tL is the mean incubation time
%   tI is the mean recovery time
%   e0 is the initial latent fraction
%   i0 is the initial infectious fraction
%   r0 is the initial immune fraction
%   target is the infected fraction used as an end condition
%   maxdays is the maximum simulation duration

% by Glenn Ledder
% written 2020/11/27
% revised 2021/03/13

% direct comments to gledder@unl.edu

%% SCENARIO DATA

R0 = 5;
tL = 5;
tI = 10;
e0 = .0001;
i0 = 0;
r0 = 0;

%% COMMON DATA

target = 0.001;
maxdays = 1000;

%% INITIALIZATION

clf
hold on
box on
colors = get(gca,'colororder');

%% COMPUTATION

[S,E,I,R,sinfty] = seir(R0,tL,tI,e0,i0,r0,target,maxdays);
days = length(I)-1;
new = S(1:days)-S(2:length(S));
new = [0;new];

%% OUTPUT

times = 0:days;

plot(times,S,'Color',colors(1,:),'LineWidth',1.4)
plot(times,E,'Color',colors(3,:),'LineWidth',1.4)
plot(times,I,'Color',colors(2,:),'LineWidth',1.4)
plot(times,R,'Color',colors(4,:),'LineWidth',1.4)

% use 'FontSize',18 in Octave
xlabel('days','FontSize',14)

% use 'FontSize',16 in Octave
ylabel('population fraction','FontSize',12)

legend('S','E','I','R','Location','West')

results = [times',S,E,I,R,new]
[M,J] = max(I);
maxI = M
maxday = J-1
finalS = sinfty
