%% SEAIHRD_onesim

% Plots a comparison of population classes

% Prints results and outcomes (populations are fractions):
%   results is a matrix of columns for time,S,E,A,I1,I2,H,R,D
%   finalpctS is the final ending susceptible fraction
%   finalpctD is the total percentage who die
%   USdeaths is the number of US deaths in thousands
%   maxHp100K is the maximum hospitalization count per 100K
%   maxnewp100K is the maximum count of new infections

% Uses seaihrd.m, 2022/03/06 version

% User specifies values for 4 parameters:
%   R0 is the basic reproductive number
%   c is the fraction of infectious patients (I+J) who are confirmed
%   delta is the contact factor
%   h0 is the initial hopitalization count per 100K

% by Glenn Ledder
% written 2022/01/23
% revised 2022/03/06

% direct comments to gledder@unl.edu

beds = 280;

%% SCENARIO DATA

R0 = 5.7;
c = 0;
delta = 1;
h0 = 1;

%% INITIALIZATION

clf
for k=1:4
    subplot(2,2,k)
    hold on
    box on
    xlabel('days')
end
colors = get(gca,'colororder');

%% COMPUTATION

[S,E,A,I,J,H,R,D] = seaihrd(R0,c,delta,h0);
days = length(I)-1;
new = S(1:days)-S(2:length(S));
new = [0;new];

%% OUTPUT

times = 0:days;

subplot(2,2,1)
plot(times,S,'Color',colors(1,:),'LineWidth',2)
plot(times,E,'Color',colors(3,:),'LineWidth',2)
plot(times,A+I+J+H,'Color',colors(2,:),'LineWidth',2)
plot(times,R+D,'Color',colors(4,:),'LineWidth',2)
ylabel('population fraction')
legend('S','E','A+I+H','R+D','Location','East')

subplot(2,2,3)
plot(times,325000*D,'r','LineWidth',2)
ylabel('US deaths (thousands)')

subplot(2,2,2)
plot(times,100000*new,'Color',colors(3,:),'LineWidth',2)
ylabel('new cases per 100K')

subplot(2,2,4)
plot(times,100000*H,'Color',colors(2,:),'LineWidth',2)
plot([0,days],[beds,beds],'k--')
ylabel('hospitalizations per 100K')

results = [times',S,E,A,I+J,H,R,D,new]

% final %S
finalpctS = 100*S(end)

% final %D
finalpctD = 100*D(end)

% US deaths (thousands)
USdeaths = 325000*D(end)

% maximum hospitalizations per 100K
maxHp100K = 100000*max(H)

% maximum new infections per 100K
maxnewp100K = 100000*max(new)
