function [Rnought,RSS]=R0fit()

% fits data from an epidemic simulation to a theoretical model
% assumes all but R0 are known

% uses findmin.m to do the optimization
% uses seirabm.m or comparable program to run simulation
% uses seir.m or comparable program to run model

% by Glenn Ledder 
% written 2021/09/10
% revised 2021/09/13

% direct comments to gledder@unl.edu

%% DATA

% Choose simulation parameters
R0 = 5;
N = 10000;

% Model parameters to match built-in simulation parameters
tL = 5;
tI = 10;
e0 = 0.0001;
i0 = 0;
r0 = 0;

% Other model parameters
target = 0.001;
maxdays = 1000;

%% INITIALIZATION

% get simulation data
[~,~,~,I,~] = seirabm(R0,N);

% plot simulation data
clf
hold on
box on
plot(I,'.')
xlim([0 120])

% use 'FontSize',18 in Octave
xlabel('days','FontSize',14)
ylabel('\it{I}','Rotation',0,'FontSize',14)

%% COMPUTATION

% define residual sum of squares function
F = @(R0) rss(R0,N,tL,tI,e0,i0,r0,target,maxdays,I);
Rnought = findmin(F,R0-1,R0+1,0.05);
RSS = rss(R0,N,tL,tI,e0,i0,r0,target,maxdays,I)

% plot best fit curve
[~,~,I_m,~,~] = seir(Rnought,tL,tI,e0,i0,r0,target,maxdays);
plot(N*I_m,'LineWidth',1.4)

%% END

end


%% FUNCTION rss(R0,N,tL,tI,e0,i0,r0,target,maxdays,I)

function z=rss(R0,N,tL,tI,e0,i0,r0,target,maxdays,I)

%   computes RSS for the SEIR epidemic model
%   I is the list of data values

% get model results
[~,~,I_m,~,~] = seir(R0,tL,tI,e0,i0,r0,target,maxdays);
I_m = N*I_m;

% match day count
L = length(I);
L_m = length(I_m);
if L_m<L
    I_m = [I_m; zeros(L-L_m,1)];
end
I_m = I_m(1:L);

% get RSS
y = (I-I_m).^2;
z = sum(y);

end


