%% PolyLS

% fits polynomials c_1+c_2*x+...c_{n+1}*x^n to data

% also reports RSS and AIC

%   x,y: row vectors of data values
%   nvals: degrees of polynomial

% Only DATA needs to be changed for each problem

% by Glenn Ledder
% written 2021/03/12
% revised 2021/03/13

%% DATA

% comment out clf to add curve(s) to existing plot

clf

% enter data

x = 0:10:140;
y = [0 2 7 10 9 14 21 20 25 20 30 25 29 35 38];
nvals = [2,3];

% choose axis labels

xname = '\it{x}';
yname = '\it{y}';

% choose curve colors

col = 'kb';     % need one for each n in nvals

%% INITIALIZE 

hold on
box on

pts = length(x);

% use 'MarkerSize',6 in Octave
plot(x,y,'r.','MarkerSize',12)

% use 'FontSize',18 in Octave
xlabel(xname,'FontSize',14);
ylabel(yname,'FontSize',14,'Rotation',0);

%% COMPUTATION and OUTPUT loop

for k=1:length(nvals)
    n = nvals(k);
    
    % find coefficients

    c = flip(polyfit(x,y,n))
    
    % find model points
    
    X = ones(n+1,pts);       
    for i=1:n
        X(i+1,:) = x.^i;        % X_ij is (x_j)^(i-1)
    end

    ymod = c*X;                 % ymod_j=c_1+c_2*x_j+c_3*x_j^2+...

    % compute RSS and AIC

    RSS = sum((y-ymod).^2)
    lnAvgRSS = log(RSS/pts);
    complexity = 2*n+4;
    AIC = pts*lnAvgRSS+complexity

    xx = linspace(x(1),x(end));
    X = ones(n+1,100);       
    for i=1:n
        X(i+1,:) = xx.^i;        % X_ij is (x_j)^(i-1)
    end
    yy = c*X;
    plot(xx,yy,col(k),'LineWidth',1.4)

end