function results=ODEsim()

% Runs a numerical simulation of a system of n differential equations.
%   dependent variables are y1, y2, ... yn

% results has columns t, y1, ..., yn

% Update both DATA and OUTPUT for new system of equations

% by Glenn Ledder
% written 2021/02/14
% revised 2021/04/02

% direct comments to gledder@unl.edu

%% DATA

% Set accuracy
%   Start with acc=0.
%   Increase acc by 1 until the graphs stop changing

acc = 0;

% Define problem parameters

b = 3;

% Define initial conditions

s0 = 0.999;
i0 = 0.001;
IC = [s0 i0];

% Define time interval

interval = [0 10];

% Define the function that determines the derivatives.

function dydt = rates(ttt,yyy)
    % Unpack variables
    s = yyy(1);
    i = yyy(2);
    % Calculate derivatives
    sp = -b*s*i;
    ip = b*s*i-i;
    % Assemble vector derivative
    dydt = [sp;ip];
end

% Define additional colors if desired

darkgreen = [0 0.6 0];

%% COMPUTATION

% Calculate a vector t and matrix yy that contains the solution at 
%   discrete points

opts = odeset('RelTol',10^-(acc+3),'AbsTol',10^-(acc+6));
[t,yy] = ode45(@rates,interval,IC,opts);
results = [t yy];


%% OUTPUT

% Set up plots

clf
hold on
box on

% Unpack solution matrix

s = yy(:,1);
i = yy(:,2);
r = 1-s-i;
plot(t,s,'b','LineWidth',1.4)
plot(t,i,'r','LineWidth',1.4)
plot(t,r,'Color',darkgreen,'LineWidth',1.4)

% use 'FontSize',18 in Octave
xlabel('\it{t}','FontSize',14)
ylabel('\it{s,i}','FontSize',14,'Rotation',0)

legend('\it{s}','\it{i}','\it{r}','Location','East')

%% END

end

