%% HPSR_onesim

% Plots the results of an HPSR agent-based model simulation

% Prints results and outcomes:
%   results is a matrix of columns for time,H,P,S,R
%   maxI is the maximum number infected
%   finalH is the ending size of H

% User specifies values for 4 parameters:
%   b is the transmission probability
%   N is the total population
%   P0 is the initial presymptomatic population
%   S0 is the original sick population

% If using Octave, add the additional option pair "'MarkerSize',2.5"
%   (without the double quotes) to the three plot statements)

% Uses hpsr.m, 2021/10/20 version

%- function [H,P,S,R]=hpsr(b,N,P0,S0)
%-
%-   runs a simulation of the HPSR agent-based disease model
%-
%-   H: healthy
%-   P: presymptomatic
%-   S: sick
%-   R: recovered
%-
%-   b is the transmission probability
%-   N is the total population
%-   P0 is the initial presymptomatic population
%-   S0 is the initial sick population

% by Glenn Ledder
% written 2020/11/29
% revised 2021/10/26

% direct comments to gledder@unl.edu

%% SCENARIO DATA

b = 5/6;
N = 1000;
P0 = 20;
S0 = 0;

%% INITIALIZATION

% set up for first figure

figure(1)
clf
darkgreen = [0 0.6 0];
hold on
box on

%% COMPUTATION

% collect simulation data
[H,P,S,R] = hpsr(b,N,P0,S0);

% record simulation duration [H(1) is for day 0]
days = length(H)-1;

%% OUTPUT

% get list of times for plot
times = 0:days;

% If using Octave, add the additional option pair "'MarkerSize',2.5"
%   (without the double quotes) to the three plot statements

% plot healthy, infected, recovered
plot(times,H,'d','Color',darkgreen,'MarkerFaceColor',darkgreen)
plot(times,P+S,'rs','MarkerFaceColor','r')
plot(times,R,'b^','MarkerFaceColor','b')
xlim([0,days])

% label axes
%   use 'FontSize',18 in Octave
xlabel('days','FontSize',14)
ylabel('populations','FontSize',14)

legend('healthy','infected','recovered','Location','East')

% display results as a matrix with columns for t, H, P, S, R
results = [times',H',P',S',R']

% report maximum simulatneously infected
maxI = max(P+S)

% report final healthy population
finalH = H(end)

%% FIGURE 2

% uncomment the lines from 101 to get a figure of log(P+S)
%   add ",'MarkerSize',2.5" to the end of this plot command in Octave
%   use 'FontSize',18 in Octave

% figure(2)
% clf
% hold on
% box on
% 
% plot(times,log(P+S),'rs','MarkerFaceColor','r')
% 
% xlabel('days','FontSize',14)
% ylabel('ln(infected)','FontSize',14)
