%% HPSR_avg

% Computes results for an HPSR agent-based model simulation

% Displays histograms and prints means and standard deviations of outcomes
%   maxI_pct is the maximum number infected, by percentage
%   finalH_pct is the ending size of H, by percentage

% Uses hpsr.m, 2021/10/20 version

%- function [H,P,S,R]=hpsr(b,N,P0,S0)
%-
%-   runs a simulation of the HPSR agent-based disease model
%-
%-   H: healthy
%-   P: presymptomatic
%-   S: sick
%-   R: recovered
%-
%-   b is the transmission probability
%-   N is the total population
%-   P0 is the initial presymptomatic population
%-   S0 is the initial sick population

% SEE SPECIAL INSTRUCTIONS FOR HISTOGRAMS IF USING OCTAVE.

% by Glenn Ledder
% written 2020/12/30
% revised 2022/04/22

% direct comments to gledder@unl.edu

%% SCENARIO DATA

b = 5/6;
N = 10000;
P0 = 30;
S0 = 20;
numruns = 400;

%% INITIALIZATION

% set up for figure

clf
for k=1:2
    subplot(1,2,k)
    hold on
end

% create row vectors

maxI = zeros(1,numruns);
finalH = zeros(1,numruns);

%% COMPUTATION

for j=1:numruns
    % run simulation
    [H,P,S,~] = hpsr(b,N,P0,S0);
    % save results
    maxI(j) = max(P+S);
    finalH(j) = H(end);
end

% convert to percentages
maxI_pct = 100*sort(maxI)/N;
finalH_pct = 100*sort(finalH)/N;

%% OUTPUT

subplot(1,2,1)
% For Octave, replace the histogram statement with the following:
% hist(maxI_pct,14,1,'FaceColor','y')
histogram(maxI_pct,'Normalization','probability','FaceColor','y','FaceAlpha',1/3)
xlabel('max I (pct)','FontSize',11)
ylabel('probability','FontSize',11)

subplot(1,2,2)
% For Octave, replace the histogram statement with the following:
% hist(finalH_pct,14,1,'FaceColor','y')
histogram(finalH_pct,'Normalization','probability','FaceColor','y','FaceAlpha',1/3)
xlabel('final H (pct)','FontSize',11)
ylabel('probability','FontSize',11)

maxI_pct_mean = mean(maxI_pct)
maxI_pct_std = std(maxI_pct)
finalH_pct_mean = mean(finalH_pct)
finalH_pct_std = std(finalH_pct)
