%%% DiscreteVar

% plots a discrete dynamic variable

% Only DATA needs to be changed for each problem

% by Glenn Ledder
% written 2021/02/15
% revised 2021/08/31

% direct comments to gledder@unl.edu

%% DATA

% define model parameters

K = 1000;
R = 1.5;

% define initial states

N0vals = [50 400];

% choose number of steps

T = 8;

% define variable name for plot

varname = '\it{N}';

% define function for N_{t+1}=g(N_t)

seqfnc = @(N) N+R*N.*(1-N/K);

%% INITIALIZATION 

% set up graph

clf
hold on
box on

%% COMPUTATION

for j=1:length(N0vals)
    N0 = N0vals(j);

    % create data structure

    N = N0*ones(1,T+1);
    
    % run simulation
    
    for i=1:T
        N(i+1) = seqfnc(N(i));
    end

    % use 'MarkerSize',6 in Octave
    plot(0:T,N,'.','MarkerSize',12)
end

%% OUTPUT

% use 'FontSize',18 in Octave
xlabel('\it{t}','FontSize',14);
ylabel(varname,'FontSize',14,'Rotation',0);

N

