function y=DecaySim()

% Runs a simulation of a natural decay process

% y is the number of undecayed particles each day

% by Glenn Ledder
% written 2020/12/27
% revised 2021/03/15

% direct comments to gledder@unl.edu

%% SCENARIO DATA

% mu is the mean decay time
% y0 is the initial count of particles
% days is the length of the simulation

mu = 10;
y0 = 100;
days = 30;

%% INITIALIZATION

% set up for figure

clf
hold on
box on

% create a row vector

y = y0*ones(1,days+1);

%% COMPUTATION

% collect y0 values from E(t;mu)

times = randexp(mu,y0);
times = sort(times);

% count undecayed particles for each day

for n=1:days
    y(n+1) = length(find(times>n));
end

%% OUTPUT

times = 0:days;

% use 'MarkerSize',6 in Octave
plot(times,y,'r.','MarkerSize',12)

% use 'FontSize',18 in Octave
xlabel('\it{t}','FontSize',14)
ylabel('\it{y}','FontSize',14,'Rotation',0)

%% END

end


%% FUNCTION for EXPONENTIAL DISTRIBUTION

function [T,Tmean,Tstd]=randexp(mu,n)
%
%   produces a row vector T of n exponentially-distributed values
%   also returns mean Tmean and standard deviation Tstd
%
%   mu is the mean time for the distribution
%   default n is 1

if nargin<2
    n = 1;
end

% collect uniformly distributed random values

X = rand(1,n);
    
% convert values to match exponential distribution

T = -mu*log(X);
Tmean = mean(T);
Tstd = std(T);

end

