function [out1,out2,out3] = GradientOfRelativeSquareErrorModel(t,x,flag,ApproxSolution,parameters)
%
% Construct the gradient vector field for parameter and initial condition search. 
% 
global NumberOfVariables NumberOfParameters SearchParaNVar
global ExpeTime ExpeData LengthOfExpeData DimensionOfExpeData RealDataSelection FitWeights ExpeDataRange

f=FitFunctions(ExpeTime,ApproxSolution(:,1:NumberOfVariables),parameters);

% Jacobian of the FitFunction w.r.t. the initial conditions evaluated at
% ExpeTime. 
InitialJacobianOfFitFunctions=zeros(DimensionOfExpeData*LengthOfExpeData,NumberOfVariables);

Jpf=[ParameterJacobianOfFitFunctions(ExpeTime,ApproxSolution(:,1:NumberOfVariables),parameters),...
    InitialJacobianOfFitFunctions]; % Extended Jacobian of the FitFunctions w.r.t. 
                                    % both parameters and initial
                                    % conditions. 
    
Jvf=VariableJacobianOfFitFunctions(ExpeTime,ApproxSolution(:,1:NumberOfVariables),parameters);

% Rearrange Jpf so that the parameters and initial conditions correspond
% to the depth-dimension of the array 'fp', the components of FitFunctions 
% to the column-dimension, and their evaluations
% at the dicrete times to the row-dimension. 
for k=1:(NumberOfParameters+NumberOfVariables) 
    for j=1:DimensionOfExpeData
    fp(:,j,k)=Jpf(DimensionOfExpeData*(j-1)+(1:LengthOfExpeData),k);
    end
end


% Rearrange Jvf so that the components of FitFunctions correspond
% to the depth-dimension of the array 'fv', the variables 
% to the column-dimension, and their evaluations
% at the dicrete times to the row-dimension. 
for j=1:DimensionOfExpeData
    fv(:,:,j)=Jvf(DimensionOfExpeData*(j-1)+(1:LengthOfExpeData),:);
end


gradofE=[];
for k=1:(NumberOfParameters+NumberOfVariables)
gradofEk=0;
for j=1:DimensionOfExpeData
    gradofEij=0;
    for i=1:LengthOfExpeData       
        gradofEij=gradofEij+RealDataSelection(i,j)*(f(i,j)- ExpeData(i,j))*(fp(i,j,k)+...
            fv(i,:,j)*ApproxSolution(i,k*NumberOfVariables+(1:NumberOfVariables))');
    end
    gradofEk=gradofEk+gradofEij*FitWeights(j)/ExpeDataRange(j)^2;
end
gradofE=[gradofE;gradofEk]; % Vector field in rows.
end



if nargin <3 | isempty(flag) 
    out1 = -gradofE.*SearchParaNVar; % Vector field in the opposite direction of the gradient.
else
    switch(flag)
        case 'init'
            out1 = [];
            out2 = [];
            out3 = []
        otherwise
            error(['Unknown flag''' flag ''.'])
    end
end

