% Method -- Least Square Fit to Differential Equation Model by Newton's
% (?)Gradient Method.
%  
% The best parameter values, initial condiations, and the realative square
% error are saved in the file 'Data.mat', for which the last point of 
% variable 'SearchPath' is the end point of the search, all points are 
% in the order of parameters and then initial points.
% 
% 
% Example -- Logisitc Equation 
%
%  To adapt it to your model, modify the input with '%%%' comments
%  and create the following m.files without change the file names:
%      
%      VariationDEModel.m
%      FitFunctions.m
%      ParameterJacobianOfFitFunctions.m
%      VariableJacobianOfFitFunctions.m
%      
%      
clear all

% Do Not Change the Following global parameters
global VariableNames ParameterNames NumberOfVariables NumberOfParameters 
global Parameters4Search InitialConditions4Search SearchParaNVar SearchParaNVarInitials 
global ExpeTime ExpeData LengthOfExpeData DimensionOfExpeData RealDataSelection FitWeights ExpeDataRange
global StopError StopIterate SearchStepSize

%%% Define parameter names, modify entries in quotations only.
ParameterNames={'a', 'r', 'm'};

%%% Specify the starting parameter values. Do Not Change the vector name. 
ParameterValues=[0   1.1661    0.5374  ];
ParameterValues(2)=.5;
ParameterValues=[0   0  0 ];

%ParameterValues=[0   0  ];

%%% Specify which parameter(s) the program is used to search and determine.
Parameters4Search={'r', 'm'};
% Parameters4Search=ParameterNames % If all the parameters are to be determined 
% Parameters4Search=[] % If none of the parameters is to be determined 
Parameters4Search={'a'};

%%% Define variable names. Modify entries in quotations only. Add more if needed. 
VariableNames={'Population'};

%%% Specify which initial(s) the program is also used to search and determine.

InitialConditions4Search={'Population'};

% InitialConditions4Search=VariableNames % if all IC are to be searched.
% InitialConditions4Search=[] % if none of the IC is to be searched.

%%% 
%%% Specify the initial conditions in a row vector. Do Not Change the vector name. 
InitialConditions=[   0.68451];
InitialConditions=[ 2];

%% 
%%%
%%% Here below is the experimental data structure for the program. 
%%%

%%%   
%%% First, name each of your data set. For example, you collected the 
%%% sighting data of dolphin and the harvesting data of tuna. So you have
%%% a two dimensional data set, and perhaps you want to use 
%%% 'DataNames = {'Dolpin Sighting', 'Tuna Catch'}'. The program is written
%%% to handle 10 dimensional data or less.

%%% For the logistic example, we just use
DataNames = {'Population'}; % Its length must be the same as 
                           % the output dimension of your 'FitFunctions'

%%% Second, edit the entries of 'FitWeights' (in one row of the same dimension
%%% as 'DataName' so that each entry is a number
%%% in [0,1], specifying the weight the Relative Square Error (RSE) weighs 
%%% on each dimensional data. For example, a FitWeights=[1/2 1/2] is for
%%% an equal weight of a 2-dimensional data set DataName = {'Dolpin
%%% Sighting', 'Tuna Catch'}
%%%
FitWeights=[1]; % Unit weight for 1-dimensional data set. 

%%% Enter the discrete times, in a column vector, at which the first 
%%% dimensional data were collected. Idential time entries are allowed.
%%% Use the exact name, ExpeTime1. 
ExpeTime1=[ 0.0055;    0.5014;    1.0015;    1.5026;    2.0084;    2.5025;  3.0081;    3.5024;    4.0093;    4.5035;    5.0020];

%%% Enter the corresponding first dimensional data in a column of the same
%%% length of ExpeTime1.
%%% Use the exact name, ExpeData1. 

%%% A data for linear fit.
ExpeData1=.32*ExpeTime1-.3+0.1*rand(length(ExpeTime1),1);

%%% A data for logistic fit
%ExpeData1=[ 0.4253;    0.9855;    1.4145;    1.6956;    1.9951;    1.9860;   2.0002;    2.1197;    1.9337;    2.0764;    2.0758];

%%% A data for general fit
%ExpeData1=[ 2.3523;    1.6710;    1.1200;    0.7488;   0.6420;    0.4345;    0.3268;    0.3550;    0.1540;    0.2440;    0.2246];
% which was generated by
% 2.3*exp(-0.83*ExpeTime1)+.25*rand(length(ExpeTime1),1)


%%% Create a column sequence of the length of ExpeData1 for the weight you put on
%%% the entries. For example, a value 1 gives an entry a full weight, 0
%%% gives none, any value in [0,1] gives a proportionated weight. This is
%%% to allow you show how confident you are about the data.
%%% 
RealDataSelection1=ones(length(ExpeData1),1); % If all ExpeData1 entries weighs equally. 

%%% For example, two points are taken out from the search because you are
%%% not sure their validity or think they are outliers. 
RealDataSelection1(end-2)=0;  
RealDataSelection1(end-7)=0;

%%% For multi-dimensional data, repeat the data entry process to enter,
%%% ExpeTime2,ExpeData2,RealDataSelection2, and so on upto
%%% ExpeTime10,ExpeData10,RealDataSelection10

%%
%%% Specify the conditions to stop the program search and other program controls. 
%%%
%%%
StopError=1e-2; % Search stops if the RelativeSquareErrors < StopError
StopIterate=150;  % Seach stops if the number of iteration exceeds StopIterate. 

SearchStepSize=.04; % Step size for the gradient search of parameter and initial conditions.
                    % Decrease it when encounter nonconvergence error
                    % message. Always decrease it by one order for consistency check. 

%%% Specify the search increment to update various diagnostic plots.                    
plotfrqncy=5;

%%% Specify the search scheme either by Euler's discretization or by
%%% Matlab's solver.
SearchScheme={'Euler'}; % 'Euler' or 'Solver'
                    
%%%%%%%%%
%%%%%%%%% With the completion of the required user-specific m.files, this
%%%%%%%%% complete the input to the program. Run it from this point on. 
%%%%%%%%%

%%
%%%%%%%%%  It is only optional to make any change below.  
%%%%%%%%%

NumberOfVariables=length(VariableNames);
NumberOfParameters=length(ParameterNames);

DimensionOfExpeData=length(DataNames);

%%% Run a data structure script 'ExpeDataConstruction' which outputs 
%%% 'ExpeTime', 'ExpeData', among others.
ExpeDataConstruction;

LengthOfExpeData=length(ExpeTime);


%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Find 'ExpeDataRange'.
%%%%%%%%%%%%%%%%%%%%

ExpeDataRange=max(ExpeData,[],1)-min(ExpeData,[],1);
ZeroDifference=(ExpeDataRange==0);
ExpeDataRange=ExpeDataRange+ZeroDifference;

%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%

nmbrofvariations=NumberOfParameters*NumberOfVariables;


% Create a binary sequence for those parameters and initial conditions with
% which the program is to find the best values. 
SearchParaNVar = SearchingVariables(Parameters4Search,InitialConditions4Search,ParameterNames,VariableNames);

tinit=min(ExpeTime);
tend=max(ExpeTime);


OldLSError=1e+8;
NewLSError=1;
counter=1;

options=odeset('RelTol',1e-4,'AbsTol',1e-6);
parameters=ParameterValues;
IdMtrx=eye(NumberOfVariables,NumberOfVariables);

SearchParaNVarInitials=ones(NumberOfVariables,1)*SearchParaNVar';
SearchParaNVarInitials=SearchParaNVarInitials(1:end)';

xinit=[InitialConditions zeros(1,nmbrofvariations) IdMtrx(1:end)].*[ones(NumberOfVariables,1);SearchParaNVarInitials]';

for DataCoordinate=1:DimensionOfExpeData
figure(DataCoordinate) %%% Figure for ExpeData1 and its fit. 
hold off
plot(ExpeTime(DataEntry(:,DataCoordinate)==1),ExpeData((DataEntry(:,DataCoordinate)==1),DataCoordinate), 'bo')
hold on
xlabel('Time')
ylabel('Data & LS Fit')
figure(DataCoordinate+DimensionOfExpeData) %%% Figure for ExpeData1 and its fit. 
hold off
plot3(0*ExpeTime(DataEntry(:,DataCoordinate)==1),ExpeTime(DataEntry(:,DataCoordinate)==1),ExpeData((DataEntry(:,DataCoordinate)==1),DataCoordinate), 'bo')
hold on
xlabel('Search Iterate')
ylabel('Time')
zlabel('Data & LS Fit')
grid on
end

SearchPath=[ParameterValues,InitialConditions];
RelativeSquareErrors=[];
%while abs(NewLSError-OldLSError)>StopError & counter<StopIterate;
while NewLSError>StopError & counter<StopIterate;
        [t,y]=ode15s('VariationDEModel',[tinit tend],xinit, options, parameters);
        yExpeData=[];
        TimeIndx=ExpeTime';
        for i=TimeIndx
            idx=(t>=i);
            aa=y(idx,:);
            yExpeData=[yExpeData;aa(1,:)];
        end
        OldLSError=NewLSError;
        NewLSError=RelativeSquareError(yExpeData,parameters);
        RelativeSquareErrors=[RelativeSquareErrors,NewLSError];
                FF=FitFunctions(t,y(:,1:NumberOfVariables),parameters);
        if counter==1
            for DataCoordinate=1:DimensionOfExpeData
                figure(DataCoordinate)
            plot(t,FF(:,DataCoordinate),'m-','linewidth',2.5)
            figure(DataCoordinate+DimensionOfExpeData)
            plot3(0*t,t,FF(:,DataCoordinate),'m-','linewidth',2.5)
            end
        end

        %%% To use Euler discretization scheme or Solver for the iteration. 
        
        tst=strcmp('Euler', SearchScheme);
        if tst==1
        z=[parameters,xinit(1:NumberOfVariables)]+GradientOfRelativeSquareErrorModel(t,y,[],yExpeData,parameters)'*SearchStepSize;
        SearchPath=[SearchPath;z];
        xinit(1:NumberOfVariables)=z(end-NumberOfVariables+1:end);
        parameters=z(1:NumberOfParameters);
        else 
        %%% To use a solver for the iteration. 
        pinit=[parameters,xinit(1:NumberOfVariables)];
        [s,z]=ode15s('GradientOfRelativeSquareErrorModel',[0 SearchStepSize],pinit,options,yExpeData, parameters);
        SearchPath=[SearchPath;z(2,:)];
        xinit(1:NumberOfVariables)=z(2,end-NumberOfVariables+1:end);
        parameters=z(2,1:NumberOfParameters);
        end
 
counter=counter+1;
if mod(counter,plotfrqncy)==0
    counter
    for DataCoordinate=1:DimensionOfExpeData
        figure(DataCoordinate)
    plot(t,FF(:,DataCoordinate),'r-')
    figure(DataCoordinate+DimensionOfExpeData)
    plot3(0*ExpeTime(DataEntry(:,DataCoordinate)==1)+counter,ExpeTime(DataEntry(:,DataCoordinate)==1),ExpeData((DataEntry(:,DataCoordinate)==1),DataCoordinate), 'b.')
    plot3(0*t+counter,t,FF(:,DataCoordinate),'r-')
    end
    figure(12)
hold off
plot([1:length(RelativeSquareErrors)],RelativeSquareErrors)
xlabel('Search Iterate')
ylabel('Relative Square Error')

figure(11)
hold off
plot3(SearchPath(:,1),SearchPath(:,2),SearchPath(:,3))
hold on
plot3(SearchPath(1,1),SearchPath(1,2),SearchPath(1,3),'m.',...
    SearchPath(end,1),SearchPath(end,2),SearchPath(end,3),'r.','markersize',10)
text(1.05*SearchPath(end,1),1.05*SearchPath(end,2),1.05*SearchPath(end,3),'End of the Search')
grid on
title('Search Path')

    save('Data.m', 'SearchPath', 'RelativeSquareErrors'); 
end

end

for DataCoordinate=1:DimensionOfExpeData
    figure(DataCoordinate)
plot(t,FF(:,DataCoordinate),'b-','linewidth',2.5)
    figure(DataCoordinate+DimensionOfExpeData)
    plot3(0*ExpeTime(DataEntry(:,DataCoordinate)==1)+counter,ExpeTime(DataEntry(:,DataCoordinate)==1),ExpeData((DataEntry(:,DataCoordinate)==1),DataCoordinate), 'bo')
    plot3(0*t+counter,t,FF(:,DataCoordinate),'b-','linewidth',2.5)
end

figure(11)
hold off
plot3(SearchPath(:,1),SearchPath(:,2),SearchPath(:,3))
hold on
plot3(SearchPath(1,1),SearchPath(1,2),SearchPath(1,3),'m.',...
    SearchPath(end,1),SearchPath(end,2),SearchPath(end,3),'r.','markersize',10)
text(1.05*SearchPath(end,1),1.05*SearchPath(end,2),1.05*SearchPath(end,3),'End of the Search')
grid on
{'Parameters','Initial Conditions', 'RelativeSquareError'}
[parameters, xinit(1:NumberOfVariables), NewLSError]

return


  