function [out1,out2,out3]=VariationDEModel(t,x, flag, parameters)
%
%
%
global NumberOfVariables NumberOfParameters SearchParaNVar SearchParaNVarInitials

a=parameters(1);
r=parameters(2);
m=parameters(3);
P=x(1:1); % For higher dimensional model, this is a column vector. 
dPda=x(2:2);
dPdr=x(3:3); % Variation of the variable vector w.r.t the first parameter. 
dPdm=x(4:4); % Analogous interpretation. 
dPdP01=x(5:5); % Variation of the variable vector w.r.t the first initial condition. 

dPdt = a+r*P-m*P.^2; % The differential equation model.
dPdadt =  1 + (r-2*m*P)*dPda;
dPdrdt =  P + (r-2*m*P)*dPdr;  % Jp(:,1) + Jv*dPdr
                               % Use first column of 'Jp' and 'Jv' from 
                               % the result of running 'Jacobians.m'.
dPdmdt =  -P.^2 + (r-2*m*P)*dPdm; % Jp(:,2) + Jv*dPdm
                                  % Use first column of 'Jp' and 'Jv' from 
                                  % the result of running 'Jacobians.m'.
dPdP01dt = 0 + (r-2*m*P)*dPdP01;  % 0 + Jv*dPdP0, Vector 0 is the variation of the 
                                  % equation w.r.t the individiual initial
                                  % conditions. Use 'Jv' from 
                                  % the result of running 'Jacobians.m'.

if nargin <3 | isempty(flag) 
    out1 = [dPdt;[dPdadt;dPdrdt;dPdmdt;dPdP01dt].*SearchParaNVarInitials]; % The right hand of the variational equations.                                  
else
    switch(flag)
        case 'init'
            out1 = [];
            out2 = [];
            out3 = []
        otherwise
            error(['Unknown flag''' flag ''.'])
    end
end

